<?php

namespace Database\Seeders\Auth;

use App\Models\Core\Auth\Permission;
use App\Models\Core\Auth\Type;
use Database\Seeders\Traits\DisableForeignKeys;
use Illuminate\Database\Seeder;

class PermissionTableSeeder extends Seeder
{
    use DisableForeignKeys;

    /**
     * Run the database seeders.
     *
     * @return void
     */
    public function run()
    {
        $this->disableForeignKeys();
        Permission::query()->truncate();
        $appId = Type::findByAlias('app')->id;

        $permissions = [
            // custom_fields
            [
                'name' => 'view_custom_fields',
                'type_id' => $appId,
                'group_name' => 'custom_fields'
            ],
            [
                'name' => 'create_custom_fields',
                'type_id' => $appId,
                'group_name' => 'custom_fields'
            ],
            [
                'name' => 'update_custom_fields',
                'type_id' => $appId,
                'group_name' => 'custom_fields'
            ],
            [
                'name' => 'delete_custom_fields',
                'type_id' => $appId,
                'group_name' => 'custom_fields'
            ],
//            end custom_fields

//        notification_events start
            [
                'name' => 'attach_templates_notification_events',
                'type_id' => $appId,
                'group_name' => 'notification_events'
            ],
            [
                'name' => 'detach_templates_notification_events',
                'type_id' => $appId,
                'group_name' => 'notification_events'
            ],
//            notification_events end

            //log start
            [
                'name' => 'view_activity_logs',
                'type_id' => $appId,
                'group_name' => 'log'
            ],
            //        log end

            //users
            /*   [
                   'name' => 'view_users',
                   'type_id' => $appId,
                   'group_name' => 'users'
               ],
               [
                   'name' => 'manage_dashboard',
                   'type_id' => $appId,
                   'group_name' => 'dashboard'
               ],
               [
                   'name' => 'create_users',
                   'type_id' => $appId,
                   'group_name' => 'users'
               ],
               [
                   'name' => 'update_users',
                   'type_id' => $appId,
                   'group_name' => 'users'
               ],
               [
                   'name' => 'delete_users',
                   'type_id' => $appId,
                   'group_name' => 'users'
               ],
               [
                   'name' => 'cancel_user_invitation',
                   'type_id' => $appId,
                   'group_name' => 'users'
               ],
               [
                   'name' => 'attach_roles_users',
                   'type_id' => $appId,
                   'group_name' => 'users'
               ],
               [
                   'name' => 'detach_roles_users',
                   'type_id' => $appId,
                   'group_name' => 'users'
               ],
                [
//                'name' => 'invite_user',
//                'type_id' => $appId,
//                'group_name' => 'users'
//            ],

            */
            //end users

            //roles
//            [
//                'name' => 'view_roles',
//                'type_id' => $appId,
//                'group_name' => 'roles'
//            ],
//            [
//                'name' => 'create_roles',
//                'type_id' => $appId,
//                'group_name' => 'roles'
//            ],
//            [
//                'name' => 'update_roles',
//                'type_id' => $appId,
//                'group_name' => 'roles'
//            ],
//            [
//                'name' => 'delete_roles',
//                'type_id' => $appId,
//                'group_name' => 'roles'
//            ],
//            [
//                'name' => 'attach_users_to_roles',
//                'type_id' => $appId,
//                'group_name' => 'roles'
//            ],
//            [
//                'name' => 'attach_permissions_roles',
//                'type_id' => $appId,
//                'group_name' => 'permissions'
//            ],
//            [
//                'name' => 'detach_permissions_roles',
//                'type_id' => $appId,
//                'group_name' => 'permissions'
//            ],
            //roles

            //settings
//            [
//                'name' => 'view_settings',
//                'type_id' => $appId,
//                'group_name' => 'settings'
//            ],
//            [
//                'name' => 'update_settings',
//                'type_id' => $appId,
//                'group_name' => 'settings'
//            ],
//            /*[
//                'name' => 'change_password_users',
//                'type_id' => $appId,
//                'group_name' => 'users'
//            ],*/
//          /*  [
//                'name' => 'change_profile_picture_users',
//                'type_id' => $appId,
//                'group_name' => 'users'
//            ],*/
//            [
//                'name' => 'update_delivery_settings',
//                'type_id' => $appId,
//                'group_name' => 'settings'
//            ],
//            [
//                'name' => 'view_delivery_settings',
//                'type_id' => $appId,
//                'group_name' => 'settings'
//            ],
//            [
//                'name' => 'view_brand_delivery_settings',
//                'type_id' => $appId,
//                'group_name' => 'settings'
//            ],
//            [
//                'name' => 'update_brand_privacy_settings',
//                'type_id' => $appId,
//                'group_name' => 'settings'
//            ],
//            [
//                'name' => 'view_brand_privacy_settings',
//                'type_id' => $appId,
//                'group_name' => 'settings'
//            ],
//            [
//                'name' => 'view_notification_settings',
//                'type_id' => $appId,
//                'group_name' => 'settings'
//            ],
//            [
//                'name' => 'update_notification_settings',
//                'type_id' => $appId,
//                'group_name' => 'settings'
//            ],
            //end of settings

            //Notification Templates
//            [
//                'name' => 'view_notification_templates',
//                'type_id' => $appId,
//                'group_name' => 'templates'
//            ],
//            [
//                'name' => 'create_notification_templates',
//                'type_id' => $appId,
//                'group_name' => 'templates'
//            ],
//            [
//                'name' => 'update_notification_templates',
//                'type_id' => $appId,
//                'group_name' => 'templates'
//            ],
//            [
//                'name' => 'delete_notification_templates',
//                'type_id' => $appId,
//                'group_name' => 'templates'
//            ],

//            [
//                'name' => 'update_corn_job_settings',
//                'type_id' => $appId
//            ],
//            [
//                'name' => 'view_corn_job_settings',
//                'type_id' => $appId
//            ],

            //Template start
//            [
//                'name' => 'view_templates',
//                'type_id' => $appId,
//                'group_name' => 'templates'
//            ],
//            [
//                'name' => 'create_templates',
//                'type_id' => $appId,
//                'group_name' => 'templates'
//            ],
//            [
//                'name' => 'update_templates',
//                'type_id' => $appId,
//                'group_name' => 'templates'
//            ],
//            [
//                'name' => 'delete_templates',
//                'type_id' => $appId,
//                'group_name' => 'templates'
//            ],
            //        end template

            //Branch
            /*
            [
                'name' => 'view_branch',
                'type_id' => $appId,
                'group_name' => 'branch'
            ],
            [
                'name' => 'create_branch',
                'type_id' => $appId,
                'group_name' => 'branch'
            ],
            [
                'name' => 'update_branch',
                'type_id' => $appId,
                'group_name' => 'branch'
            ],
            [
                'name' => 'delete_branch',
                'type_id' => $appId,
                'group_name' => 'branch'
            ],

            //Tax
            [
                'name' => 'view_tax',
                'type_id' => $appId,
                'group_name' => 'tax'
            ],
            [
                'name' => 'create_tax',
                'type_id' => $appId,
                'group_name' => 'tax'
            ],
            [
                'name' => 'update_tax',
                'type_id' => $appId,
                'group_name' => 'tax'
            ],
            [
                'name' => 'delete_tax',
                'type_id' => $appId,
                'group_name' => 'tax'
            ],
            //POS/Booking Settings
            [
                'name' => 'view_pos_settings',
                'type_id' => $appId,
                'group_name' => 'pos_settings'
            ],
            [
                'name' => 'view_tax_management',
                'type_id' => $appId,
                'group_name' => 'tax_management'
            ],

            //Supplier
            [
                'name' => 'view_supplier',
                'type_id' => $appId,
                'group_name' => 'supplier'
            ],
            [
                'name' => 'create_supplier',
                'type_id' => $appId,
                'group_name' => 'supplier'
            ],
            [
                'name' => 'update_supplier',
                'type_id' => $appId,
                'group_name' => 'supplier'
            ],
            [
                'name' => 'delete_supplier',
                'type_id' => $appId,
                'group_name' => 'supplier'
            ],

            //Payment Method
            [
                'name' => 'view_payment_method',
                'type_id' => $appId,
                'group_name' => 'payment_method'
            ],
            [
                'name' => 'create_payment_method',
                'type_id' => $appId,
                'group_name' => 'payment_method'
            ],
            [
                'name' => 'update_payment_method',
                'type_id' => $appId,
                'group_name' => 'payment_method'
            ],
            [
                'name' => 'delete_payment_method',
                'type_id' => $appId,
                'group_name' => 'payment_method'
            ],

            // Details permissions
            [
                'name' => 'view_customers',
                'type_id' => $appId,
                'group_name' => 'customers'
            ],
            [
                'name' => 'create_customers',
                'type_id' => $appId,
                'group_name' => 'customers'
            ],
            [
                'name' => 'update_customers',
                'type_id' => $appId,
                'group_name' => 'customers'
            ],
            [
                'name' => 'delete_customers',
                'type_id' => $appId,
                'group_name' => 'customers'
            ],

            // Details Group permissions

            [
                'name' => 'view_customer_groups',
                'type_id' => $appId,
                'group_name' => 'customer_groups'
            ],
            [
                'name' => 'create_customer_groups',
                'type_id' => $appId,
                'group_name' => 'customer_groups'
            ],
            [
                'name' => 'update_customer_groups',
                'type_id' => $appId,
                'group_name' => 'customer_groups'
            ],
            [
                'name' => 'delete_customer_groups',
                'type_id' => $appId,
                'group_name' => 'customer_groups'
            ],

            // Invoice Template permissions
            [
                'name' => 'view_invoice_templates',
                'type_id' => $appId,
                'group_name' => 'invoice_templates'
            ],
            [
                'name' => 'create_invoice_templates',
                'type_id' => $appId,
                'group_name' => 'invoice_templates'
            ],
            [
                'name' => 'update_invoice_templates',
                'type_id' => $appId,
                'group_name' => 'invoice_templates'
            ],
            [
                'name' => 'delete_invoice_templates',
                'type_id' => $appId,
                'group_name' => 'invoice_templates'
            ],

            //Coupon
            [
                'name' => 'view_coupon',
                'type_id' => $appId,
                'group_name' => 'coupon'
            ],
            [
                'name' => 'create_coupon',
                'type_id' => $appId,
                'group_name' => 'coupon'
            ],
            [
                'name' => 'update_coupon',
                'type_id' => $appId,
                'group_name' => 'coupon'
            ],
            [
                'name' => 'delete_coupon',
                'type_id' => $appId,
                'group_name' => 'coupon'
            ],

            //Variant Attribute
            [
                'name' => 'export_attributes',
                'type_id' => $appId,
                'group_name' => 'attribute'
            ],
            [
                'name' => 'view_attribute',
                'type_id' => $appId,
                'group_name' => 'attribute'
            ],
            [
                'name' => 'create_attribute',
                'type_id' => $appId,
                'group_name' => 'attribute'
            ],
            [
                'name' => 'update_attribute',
                'type_id' => $appId,
                'group_name' => 'attribute'
            ],
            [
                'name' => 'delete_attribute',
                'type_id' => $appId,
                'group_name' => 'attribute'
            ],
            //Category
            [
                'name' => 'export_categories',
                'type_id' => $appId,
                'group_name' => 'category'
            ],
            [
                'name' => 'view_category',
                'type_id' => $appId,
                'group_name' => 'category'
            ],
            [
                'name' => 'create_category',
                'type_id' => $appId,
                'group_name' => 'category'
            ],
            [
                'name' => 'update_category',
                'type_id' => $appId,
                'group_name' => 'category'
            ],
            [
                'name' => 'delete_category',
                'type_id' => $appId,
                'group_name' => 'category'
            ],
            //Customer
            [
                'name' => 'view_customer',
                'type_id' => $appId,
                'group_name' => 'customer'
            ],
            [
                'name' => 'create_customer',
                'type_id' => $appId,
                'group_name' => 'customer'
            ],
            [
                'name' => 'update_customer',
                'type_id' => $appId,
                'group_name' => 'customer'
            ],
            [
                'name' => 'delete_customer',
                'type_id' => $appId,
                'group_name' => 'customer'
            ],

            //Unit
            [
                'name' => 'view_unit',
                'type_id' => $appId,
                'group_name' => 'unit'
            ],
            [
                'name' => 'create_unit',
                'type_id' => $appId,
                'group_name' => 'unit'
            ],
            [
                'name' => 'update_unit',
                'type_id' => $appId,
                'group_name' => 'unit'
            ],
            [
                'name' => 'delete_unit',
                'type_id' => $appId,
                'group_name' => 'unit'
            ],

            //Brand
            [
                'name' => 'view_brand',
                'type_id' => $appId,
                'group_name' => 'brand'
            ],
            [
                'name' => 'create_brand',
                'type_id' => $appId,
                'group_name' => 'brand'
            ],
            [
                'name' => 'update_brand',
                'type_id' => $appId,
                'group_name' => 'brand'
            ],
            [
                'name' => 'delete_brand',
                'type_id' => $appId,
                'group_name' => 'brand'
            ],
            //Group
            [
                'name' => 'export_groups',
                'type_id' => $appId,
                'group_name' => 'group'
            ],
            [
                'name' => 'view_group',
                'type_id' => $appId,
                'group_name' => 'group'
            ],
            [
                'name' => 'create_group',
                'type_id' => $appId,
                'group_name' => 'group'
            ],
            [
                'name' => 'update_group',
                'type_id' => $appId,
                'group_name' => 'group'
            ],
            [
                'name' => 'delete_group',
                'type_id' => $appId,
                'group_name' => 'group'
            ],

            //Sub Group
            [
                'name' => 'export_sub_group',
                'type_id' => $appId,
                'group_name' => 'sub_group'
            ],
            [
                'name' => 'view_sub_group',
                'type_id' => $appId,
                'group_name' => 'sub_group'
            ],
            [
                'name' => 'create_sub_group',
                'type_id' => $appId,
                'group_name' => 'sub_group'
            ],
            [
                'name' => 'update_sub_group',
                'type_id' => $appId,
                'group_name' => 'sub_group'
            ],
            [
                'name' => 'delete_sub_group',
                'type_id' => $appId,
                'group_name' => 'sub_group'
            ],

            [
                'name' => 'view_sales',
                'type_id' => $appId,
                'group_name' => 'sales'
            ],
            [
                'name' => 'view_returns',
                'type_id' => $appId,
                'group_name' => 'returns'
            ],
            [
                'name' => 'view_invoice',
                'type_id' => $appId,
                'group_name' => 'invoice'
            ],
            [
                'name' => 'view_cash_counter',
                'type_id' => $appId,
                'group_name' => 'cash_counter'
            ],
            [
                'name' => 'view_expense',
                'type_id' => $appId,
                'group_name' => 'expense'
            ],
            [
                'name' => 'view_expense_type',
                'type_id' => $appId,
                'group_name' => 'expense_type'
            ],
            [
                'name' => 'view_discount',
                'type_id' => $appId,
                'group_name' => 'discount'
            ],
            [
                'name' => 'view_tax_management',
                'type_id' => $appId,
                'group_name' => 'tax_management'
            ],
            [
                'name' => 'view_reports',
                'type_id' => $appId,
                'group_name' => 'reports'
            ],
*/
        ];

        $this->enableForeignKeys();
        Permission::query()->insert($permissions);
    }
}
