<?php

namespace Database\Seeders\Auth;

use App\Models\Core\Auth\Permission;
use App\Models\Core\Auth\Role;
use Database\Seeders\Traits\DisableForeignKeys;
use Illuminate\Database\Seeder;

class ManagerPermissionSeeder extends Seeder
{
    use DisableForeignKeys;

    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $this->disableForeignKeys();

        $manager = Role::query()
            ->where('id', 2) //manager
            ->first();

        $manager_permissions = null;
        for ($i = 1; $i <= 127; ++$i) {
            if(in_array($i, [2,3,4,5,6,7,8,9,10])) continue;
            $manager_permissions[] = $i;
        }

        $manager->permissions()->attach($manager_permissions);

        $this->enableForeignKeys();
    }
}
