<?php

namespace Database\Seeders\Auth;

use App\Models\Core\Auth\Role;
use Database\Seeders\Traits\DisableForeignKeys;
use Illuminate\Database\Seeder;

class BranchManagerPermissionSeeder extends Seeder
{
    use DisableForeignKeys;
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $this->disableForeignKeys();

        $branch_manager = Role::query()
            ->where('id', 4) //branch manager
            ->first();

        $branch_manager_permissions = null;
        for ($i = 27; $i <= 127; ++$i) $branch_manager_permissions[] = $i;
        $total_permissions = array_merge([1], $branch_manager_permissions);
        $branch_manager->permissions()->attach($total_permissions);

        $this->enableForeignKeys();
    }
}
